AWS Beanstalk Multi-app Sample
=================

This sample will show how multiple applications can be built and deployed to a single Windows Server Beanstalk environment. To build and deploy these applications, you must have the Microsoft .NET Core SDK installed on your machine.

Prerequisites:

1. Microsoft .NET Core SDK: https://www.microsoft.com/net/download

Build & Deploy:

1. Navigate to each application's folder via comand prompt, and run "dotnet restore" to restore the application's dependencies, then "dotnet publish" to build the application.
2. The application bits will be in "bin\Debug\netcoreapp1.0\publish" of each application's folder. Add the contents of the publish output folder to a zip file.
3. Move each zip to a common directory along side "aws-windows-deployment-manifest.json" file.
4. Make sure to reference each application's source bundle name and application path in its respective section in the manifest(see sample manifest in this repo).
5. Zip the manifest and application zip files into one master zip file.
6. Deploy the master zip to a v1.2.0 Beanstalk Windows Server environment.
7. Once deployment has completed, the ASP.NET app will be accessible at "/", and the Web API app will be available at "/api/values", unless you've modifed the application paths manifest.