AWS Elastic Beanstalk Windows Multi-app Sample
=================

This sample will show how multiple applications can be built and deployed to a Windows Server Elastic Beanstalk environment. To build and deploy these applications, you must have the Microsoft .NET Core SDK installed on your machine.

This package contains the source code for the Windows Multiapp sample. The ready to deploy source bundle is also in this package under the name: `dotnet-multiapp-sample-bundle-v2`.

### Prerequisites:

Microsoft .NET SDK 6.0+: https://www.microsoft.com/net/download

### Build Application:

1. Navigate to each application's folder in the terminal, and run `dotnet publish` to build the application.
2. The application bits will be in `bin\Debug\net6.0\publish` of each application's folder. Add the contents of the publish output folder to a zip file.
3. Move each zip to a common directory alongside the `aws-windows-deployment-manifest.json` file.
4. Make sure to reference each application's source bundle name and application path in its respective section in the manifest(see sample manifest in this repo).
5. Zip the manifest and application zip files into one master zip file.

### Deploy Application

1. Deploy the application source bundle created in the previous section to an Elastic Beanstalk Windows Server environment.
1. Once deployment has completed, the DotNet app will be accessible at "/", and the Web API app will be available at "/api", unless you've modifed the application paths manifest.