/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.AWSXRayRecorderBuilder;
import com.amazonaws.xray.ThreadLocalStorage;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.entities.TraceReference;
import com.amazonaws.xray.exceptions.SegmentNotFoundException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AWSXRay {
    private static AWSXRayRecorder globalRecorder = AWSXRayRecorderBuilder.defaultRecorder();

    public static AWSXRayRecorder getGlobalRecorder() {
        return globalRecorder;
    }

    public static void setGlobalRecorder(AWSXRayRecorder globalRecorder) {
        AWSXRay.globalRecorder = globalRecorder;
    }

    public static <R> R createSegment(String name, Function<Segment, R> function) {
        return globalRecorder.createSegment(name, function);
    }

    public static void createSegment(String name, Consumer<Segment> consumer) {
        globalRecorder.createSegment(name, consumer);
    }

    public static <R> R createSegment(String name, Supplier<R> supplier) {
        return globalRecorder.createSegment(name, supplier);
    }

    public static void createSegment(String name, Runnable runnable) {
        globalRecorder.createSegment(name, runnable);
    }

    public static <R> R createSubsegment(String name, Function<Subsegment, R> function) {
        return globalRecorder.createSubsegment(name, function);
    }

    public static void createSubsegment(String name, Consumer<Subsegment> consumer) {
        globalRecorder.createSubsegment(name, consumer);
    }

    public static <R> R createSubsegment(String name, Supplier<R> supplier) {
        return globalRecorder.createSubsegment(name, supplier);
    }

    public static void createSubsegment(String name, Runnable runnable) {
        globalRecorder.createSubsegment(name, runnable);
    }

    public static Segment beginSegment(String name) {
        return globalRecorder.beginSegment(name);
    }

    public static Segment beginSegment(String name, TraceID traceId, String parentId) {
        return globalRecorder.beginSegment(name, traceId, parentId);
    }

    public static void endSegment() {
        globalRecorder.endSegment();
    }

    public static Subsegment beginSubsegment(String name) {
        return globalRecorder.beginSubsegment(name);
    }

    public static void endSubsegment() {
        globalRecorder.endSubsegment();
    }

    public static String currentEntityId() {
        if (null != ThreadLocalStorage.get()) {
            return ThreadLocalStorage.get().getId();
        }
        throw new SegmentNotFoundException("Thread failed to get current entity ID: segment or subsegment cannot be found.");
    }

    public static TraceID currentTraceId() {
        if (null != AWSXRay.getCurrentSegment()) {
            return AWSXRay.getCurrentSegment().getTraceId();
        }
        throw new SegmentNotFoundException("Thread failed to get current trace ID: segment cannot be found.");
    }

    public static Segment getCurrentSegment() {
        return globalRecorder.getCurrentSegment();
    }

    public static Subsegment getCurrentSubsegment() {
        return globalRecorder.getCurrentSubsegment();
    }

    public static void infectThreadLocal(TraceReference traceReference) {
        globalRecorder.infectThreadLocal(traceReference);
    }

    public static TraceReference getThreadLocal() {
        return globalRecorder.getThreadLocal();
    }

    public static void clearThreadLocal() {
        globalRecorder.clearThreadLocal();
    }

    public static boolean sendSegment(Segment segment) {
        return globalRecorder.sendSegment(segment);
    }
}

