/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.ThreadLocalStorage;
import com.amazonaws.xray.emitters.DefaultEmitter;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.DummySegment;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.SegmentImpl;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.SubsegmentImpl;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.entities.TraceReference;
import com.amazonaws.xray.exceptions.SegmentNotFoundException;
import com.amazonaws.xray.exceptions.SubsegmentNotFoundException;
import com.amazonaws.xray.strategy.DefaultPrioritizationStrategy;
import com.amazonaws.xray.strategy.DefaultStreamingStrategy;
import com.amazonaws.xray.strategy.DefaultThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.PrioritizationStrategy;
import com.amazonaws.xray.strategy.StreamingStrategy;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.sampling.DefaultSamplingStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSXRayRecorder {
    private static final Log logger = LogFactory.getLog(AWSXRayRecorder.class);
    private SamplingStrategy samplingStrategy = new DefaultSamplingStrategy();
    private StreamingStrategy streamingStrategy = new DefaultStreamingStrategy();
    private PrioritizationStrategy prioritizationStrategy = new DefaultPrioritizationStrategy();
    private ThrowableSerializationStrategy throwableSerializationStrategy = new DefaultThrowableSerializationStrategy();
    private Emitter emitter = new DefaultEmitter();
    private Map<String, Object> runtimeContext = new ConcurrentHashMap<String, Object>();
    private String origin;
    private static final String LAMBDA_ORIGIN = "AWS::Lambda::Function";
    private static ConcurrentHashMap<String, Entity> entityReferenceMap = new ConcurrentHashMap();

    public boolean sendSegment(Segment segment) {
        if (segment.isSampled()) {
            return this.emitter.sendSegment(segment);
        }
        return false;
    }

    public <R> R createSegment(String name, Function<Segment, R> function) {
        Segment segment = this.beginSegment(name);
        try {
            R r = function.apply(segment);
            return r;
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public void createSegment(String name, Consumer<Segment> consumer) {
        Segment segment = this.beginSegment(name);
        try {
            consumer.accept(segment);
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public <R> R createSegment(String name, Supplier<R> supplier) {
        Segment segment = this.beginSegment(name);
        try {
            R r = supplier.get();
            return r;
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public void createSegment(String name, Runnable runnable) {
        Segment segment = this.beginSegment(name);
        try {
            runnable.run();
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public <R> R createSubsegment(String name, Function<Subsegment, R> function) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            R r = function.apply(subsegment);
            return r;
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public void createSubsegment(String name, Consumer<Subsegment> consumer) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            consumer.accept(subsegment);
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public <R> R createSubsegment(String name, Supplier<R> supplier) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            R r = supplier.get();
            return r;
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public void createSubsegment(String name, Runnable runnable) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            runnable.run();
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public Segment beginSegment(String name) {
        return this.beginSegment(new SegmentImpl(this, name));
    }

    public Segment beginSegment(String name, TraceID traceId, String parentId) {
        SegmentImpl segment = new SegmentImpl(this, name, traceId);
        segment.setParentId(parentId);
        return this.beginSegment(segment);
    }

    public Segment beginDummySegment() {
        return this.beginSegment(new DummySegment(this));
    }

    private Segment beginSegment(Segment segment) {
        if (ThreadLocalStorage.any()) {
            logger.error((Object)"Thread beginning new segment while another segment in progress. Overwriting current segment.");
        }
        segment.setAws(this.runtimeContext);
        if (null != this.getOrigin()) {
            segment.setOrigin(this.getOrigin());
        }
        ThreadLocalStorage.set(segment);
        return segment;
    }

    public void endSegment() {
        Segment segment;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Ending segment.");
        }
        if (ThreadLocalStorage.any()) {
            segment = ThreadLocalStorage.get().getParentSegment();
            if (segment.end()) {
                this.sendSegment(segment);
            }
        } else {
            throw new SegmentNotFoundException("Thread failed to end segment: segment cannot be found.");
        }
        entityReferenceMap.remove(segment.getTraceId());
        ThreadLocalStorage.clear();
    }

    public Subsegment beginSubsegment(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Beginning subsegment: " + name));
        }
        if (ThreadLocalStorage.any()) {
            Segment parentSegment = ThreadLocalStorage.get().getParentSegment();
            SubsegmentImpl subsegment = new SubsegmentImpl(this, name, parentSegment);
            Entity parent = ThreadLocalStorage.get();
            subsegment.setParent(parent);
            parent.addSubsegment(subsegment);
            ThreadLocalStorage.set(subsegment);
            return subsegment;
        }
        throw new SegmentNotFoundException("Thread failed to begin a subsegment: segment cannot be found.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endSubsegment() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ending subsegment named: " + ThreadLocalStorage.get().getName()));
        }
        if (!ThreadLocalStorage.any()) throw new SegmentNotFoundException("Thread failed to end a subsegment: segment cannot be found.");
        Entity current = ThreadLocalStorage.get();
        if (!(current instanceof Subsegment)) throw new SubsegmentNotFoundException("Thread failed to end a subsegment: subsegment cannot be found.");
        Subsegment currentSubsegment = (Subsegment)current;
        if (currentSubsegment.end()) {
            this.sendSegment(currentSubsegment.getParentSegment());
            return;
        } else {
            if (this.streamingStrategy.requiresStreaming(currentSubsegment.getParentSegment())) {
                this.streamingStrategy.streamSome(currentSubsegment.getParentSegment(), this.emitter);
            }
            ThreadLocalStorage.set(current.getParent());
        }
    }

    public Segment getCurrentSegment() {
        Entity current = ThreadLocalStorage.get();
        if (current instanceof Segment) {
            return (Segment)current;
        }
        if (current instanceof Subsegment) {
            return ((Subsegment)current).getParentSegment();
        }
        return null;
    }

    public Subsegment getCurrentSubsegment() {
        Entity current = ThreadLocalStorage.get();
        if (null == current) {
            throw new SegmentNotFoundException("Thread has no segment in progress.");
        }
        if (current instanceof Subsegment) {
            return (Subsegment)current;
        }
        throw new SubsegmentNotFoundException("Thread's segment has no subsegments.");
    }

    public void infectThreadLocal(TraceReference traceReference) {
        Entity referencedEntity = entityReferenceMap.get(traceReference.getTraceId());
        if (null == referencedEntity) {
            logger.warn((Object)"TraceReference thread local with a null entity.");
        }
        ThreadLocalStorage.set(referencedEntity);
    }

    public TraceReference getThreadLocal() {
        if (ThreadLocalStorage.any()) {
            String traceId = ThreadLocalStorage.get().getParentSegment().getTraceId().toString();
            entityReferenceMap.put(traceId, ThreadLocalStorage.get());
            return new TraceReference(traceId);
        }
        throw new SegmentNotFoundException();
    }

    public void clearThreadLocal() {
        ThreadLocalStorage.clear();
    }

    public void putRuntimeContext(String key, Object value) {
        if (null == value) {
            value = "";
        }
        this.runtimeContext.put(key, value);
    }

    public SamplingStrategy getSamplingStrategy() {
        return this.samplingStrategy;
    }

    public void setSamplingStrategy(SamplingStrategy samplingStrategy) {
        this.samplingStrategy = samplingStrategy;
    }

    public StreamingStrategy getStreamingStrategy() {
        return this.streamingStrategy;
    }

    public void setStreamingStrategy(StreamingStrategy streamingStrategy) {
        this.streamingStrategy = streamingStrategy;
    }

    public PrioritizationStrategy getPrioritizationStrategy() {
        return this.prioritizationStrategy;
    }

    public void setPrioritizationStrategy(PrioritizationStrategy prioritizationStrategy) {
        this.prioritizationStrategy = prioritizationStrategy;
    }

    public ThrowableSerializationStrategy getThrowableSerializationStrategy() {
        return this.throwableSerializationStrategy;
    }

    public void setThrowableSerializationStrategy(ThrowableSerializationStrategy throwableSerializationStrategy) {
        this.throwableSerializationStrategy = throwableSerializationStrategy;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean forceSamplingOfCurrentSegment() {
        Segment segment;
        if (this.samplingStrategy.isForcedSamplingSupported() && !(segment = this.getCurrentSegment()).isSampled()) {
            segment.setSampled(true);
            return true;
        }
        return false;
    }

    public static String currentEntityId() {
        if (null != ThreadLocalStorage.get()) {
            return ThreadLocalStorage.get().getId();
        }
        throw new SegmentNotFoundException("Thread failed to get current entity ID: segment or subsegment cannot be found.");
    }

    public static TraceID currentTraceId() {
        if (null != ThreadLocalStorage.get()) {
            return ThreadLocalStorage.get().getParentSegment().getTraceId();
        }
        throw new SegmentNotFoundException("Thread failed to get current trace ID: segment cannot be found.");
    }
}

