/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.entities.Entity;
import java.security.SecureRandom;

public class ThreadLocalStorage {
    private static final LocalEntity CURRENT_ENTITY = new LocalEntity();
    private static final LocalSecureRandom CURRENT_RANDOM = new LocalSecureRandom();

    public static Entity get() {
        return (Entity)CURRENT_ENTITY.get();
    }

    public static boolean any() {
        return CURRENT_ENTITY.get() != null;
    }

    public static void set(Entity entity) {
        CURRENT_ENTITY.set(entity);
    }

    public static void clear() {
        CURRENT_ENTITY.remove();
    }

    public static SecureRandom getRandom() {
        return (SecureRandom)CURRENT_RANDOM.get();
    }

    static class LocalSecureRandom
    extends InheritableThreadLocal<SecureRandom> {
        LocalSecureRandom() {
        }

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    }

    static class LocalEntity
    extends InheritableThreadLocal<Entity> {
        LocalEntity() {
        }

        @Override
        protected Entity initialValue() {
            return null;
        }
    }
}

