/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.emitters;

import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPEmitter
extends Emitter {
    private static final Log logger = LogFactory.getLog(UDPEmitter.class);
    private DatagramSocket daemonSocket;
    private InetAddress address;
    private int port = 2000;
    private byte[] sendBuffer = new byte[262144];
    private static final String AGENT_ADDRESS_KEY = "_AWS_XRAY_DAEMON_ADDRESS";
    private static final String AGENT_PORT_KEY = "_AWS_XRAY_DAEMON_PORT";

    public UDPEmitter() {
        try {
            this.daemonSocket = new DatagramSocket();
            this.address = InetAddress.getLoopbackAddress();
            String envAddress = System.getenv(AGENT_ADDRESS_KEY);
            String envPortString = System.getenv(AGENT_PORT_KEY);
            try {
                if (null != envAddress) {
                    this.address = InetAddress.getByName(envAddress);
                    logger.debug((Object)("_AWS_XRAY_DAEMON_ADDRESS is set. Emitting to daemon on address " + this.address.toString()));
                }
                if (null != envPortString) {
                    int envPort;
                    this.port = envPort = Integer.parseInt(envPortString);
                    logger.debug((Object)("_AWS_XRAY_DAEMON_PORT is set. Emitting to daemon on port " + this.port));
                }
            }
            catch (NumberFormatException | SecurityException | UnknownHostException e) {
                logger.error((Object)("Error switching to provided daemon address " + envAddress + " in environment variable " + AGENT_ADDRESS_KEY + ". Using loopback address by default."), (Throwable)e);
            }
        }
        catch (SocketException e) {
            logger.error((Object)"Exception while instantiating daemon socket.", (Throwable)e);
        }
    }

    @Override
    public boolean sendSegment(Segment segment) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)segment.prettySerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + segment.serialize()).getBytes());
    }

    @Override
    public boolean sendSubsegment(Subsegment subsegment) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)subsegment.prettySerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + subsegment.streamSerialize()).getBytes());
    }

    private boolean sendData(byte[] data) {
        logger.debug((Object)"building packet");
        DatagramPacket packet = new DatagramPacket(this.sendBuffer, 262144, this.address, this.port);
        packet.setData(data);
        try {
            this.daemonSocket.send(packet);
        }
        catch (IOException e) {
            logger.error((Object)"Exception while sending segment over UDP.", (Throwable)e);
            return false;
        }
        return true;
    }
}

