/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Cause;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.serializers.CauseSerializer;
import com.amazonaws.xray.serializers.StackTraceElementSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EntityImpl
implements Entity {
    private static final Log logger = LogFactory.getLog(EntityImpl.class);
    private static final String DEFAULT_METADATA_NAMESPACE = "default";
    private String name;
    private String id;
    private String parentId;
    private double startTime;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonSerialize(using=ToStringSerializer.class)
    private TraceID traceId;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private double endTime;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean fault;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean error;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean throttle;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean inProgress;
    private String namespace;
    private List<Subsegment> subsegments;
    private Cause cause;
    private Map<String, Object> http;
    private Map<String, Object> aws;
    private Map<String, Object> sql;
    private Map<String, Map<String, Object>> metadata;
    private Map<String, Object> annotations;
    private Set<String> precursorIds;
    @JsonIgnore
    private Entity parent;
    @JsonIgnore
    private AWSXRayRecorder creator;
    protected static final ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    protected EntityImpl() {
    }

    protected EntityImpl(AWSXRayRecorder creator, String name) {
        EntityImpl.validateNotNullOrEmpty(name, "(Sub)segment name cannot be null, empty, or only whitespace.");
        EntityImpl.validateNotNull(creator);
        this.creator = creator;
        this.name = name;
        this.subsegments = new ArrayList<Subsegment>();
        this.cause = new Cause();
        this.http = new ConcurrentHashMap<String, Object>();
        this.aws = new ConcurrentHashMap<String, Object>();
        this.sql = new ConcurrentHashMap<String, Object>();
        this.annotations = new ConcurrentHashMap<String, Object>();
        this.precursorIds = new HashSet<String>();
        this.metadata = new ConcurrentHashMap<String, Map<String, Object>>();
        this.startTime = (double)Instant.now().toEpochMilli() / 1000.0;
        this.id = Entity.generateId();
        this.inProgress = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    @Override
    public boolean isFault() {
        return this.fault;
    }

    @Override
    public void setFault(boolean fault) {
        this.fault = fault;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setError(boolean error) {
        if (error) {
            this.fault = false;
        }
        this.error = error;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public Cause getCause() {
        return this.cause;
    }

    @Override
    public Map<String, Object> getHttp() {
        return this.http;
    }

    @Override
    public void setHttp(Map<String, Object> http) {
        this.http = http;
    }

    @Override
    public Map<String, Object> getAws() {
        return this.aws;
    }

    @Override
    public void setAws(Map<String, Object> aws) {
        this.aws = aws;
    }

    @Override
    public Map<String, Object> getSql() {
        return this.sql;
    }

    @Override
    public void setSql(Map<String, Object> sql) {
        this.sql = sql;
    }

    @Override
    public Map<String, Map<String, Object>> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, Map<String, Object>> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Map<String, Object> annotations) {
        this.annotations = annotations;
    }

    @Override
    public Set<String> getPrecursorIds() {
        return this.precursorIds;
    }

    @Override
    public void setPrecursorIds(Set<String> precursorIds) {
        this.precursorIds = precursorIds;
    }

    @Override
    public void addPrecursorId(String precursorId) {
        this.precursorIds.add(precursorId);
    }

    @Override
    public Entity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Entity parent) {
        this.parent = parent;
    }

    @Override
    public AWSXRayRecorder getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(AWSXRayRecorder creator) {
        this.creator = creator;
    }

    @Override
    public boolean isThrottle() {
        return this.throttle;
    }

    @Override
    public void setThrottle(boolean throttle) {
        if (throttle) {
            this.fault = false;
            this.error = true;
        }
        this.throttle = throttle;
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    @Override
    public TraceID getTraceId() {
        return this.traceId;
    }

    @Override
    public void setTraceId(TraceID traceId) {
        this.traceId = traceId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    @JsonIgnore
    public abstract Segment getParentSegment();

    @Override
    public List<Subsegment> getSubsegments() {
        return this.subsegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubsegment(Subsegment subsegment) {
        List<Subsegment> list = this.getSubsegments();
        synchronized (list) {
            this.subsegments.add(subsegment);
        }
    }

    @Override
    public void addException(Throwable exception) {
        this.setFault(true);
        this.cause.addExceptions(this.creator.getThrowableSerializationStrategy().describeInContext(exception, this.subsegments));
    }

    @Override
    public void putHttp(String key, Object value) {
        EntityImpl.validateNotNull(key);
        EntityImpl.validateNotNull(value);
        this.http.put(key, value);
    }

    @Override
    public void putAllHttp(Map<String, Object> all) {
        EntityImpl.validateNotNull(all);
        this.http.putAll(all);
    }

    @Override
    public void putAws(String key, Object value) {
        EntityImpl.validateNotNull(key);
        EntityImpl.validateNotNull(value);
        this.aws.put(key, value);
    }

    @Override
    public void putAllAws(Map<String, Object> all) {
        EntityImpl.validateNotNull(all);
        this.aws.putAll(all);
    }

    @Override
    public void putSql(String key, Object value) {
        EntityImpl.validateNotNull(key);
        EntityImpl.validateNotNull(value);
        this.sql.put(key, value);
    }

    @Override
    public void putAllSql(Map<String, Object> all) {
        EntityImpl.validateNotNull(all);
        this.sql.putAll(all);
    }

    @Override
    public void putAnnotation(String key, String value) {
        EntityImpl.validateNotNull(key);
        EntityImpl.validateNotNull(value);
        this.annotations.put(key, value);
    }

    @Override
    public void putAnnotation(String key, Number value) {
        EntityImpl.validateNotNull(key);
        EntityImpl.validateNotNull(value);
        this.annotations.put(key, value);
    }

    @Override
    public void putAnnotation(String key, Boolean value) {
        EntityImpl.validateNotNull(key);
        EntityImpl.validateNotNull(value);
        this.annotations.put(key, value);
    }

    @Override
    public void putMetadata(String key, Object object) {
        this.putMetadata(DEFAULT_METADATA_NAMESPACE, key, object);
    }

    @Override
    public void putMetadata(String namespace, String key, Object object) {
        EntityImpl.validateNotNull(namespace);
        EntityImpl.validateNotNull(key);
        if (null == object) {
            object = NullNode.instance;
        }
        this.metadata.computeIfAbsent(namespace, n -> new ConcurrentHashMap()).put(key, object);
    }

    @Override
    public String serialize() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)"Exception while serializing entity.", (Throwable)jpe);
            return "";
        }
    }

    @Override
    public String prettySerialize() {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)"Exception while serializing segment.", (Throwable)jpe);
            return "";
        }
    }

    public static void validateNotNull(Object object) {
        if (null == object) {
            throw new NullPointerException();
        }
    }

    public static void validateNotNullOrEmpty(String string, String validationErrorMessage) {
        if (null == string || string.trim().isEmpty()) {
            throw new RuntimeException(validationErrorMessage);
        }
    }

    static {
        mapper.registerModule((Module)new SimpleModule(){

            public void setupModule(Module.SetupContext setupContext) {
                super.setupModule(setupContext);
                setupContext.addBeanSerializerModifier(new BeanSerializerModifier(){

                    public JsonSerializer<?> modifySerializer(SerializationConfig serializationConfig, BeanDescription beanDescription, JsonSerializer<?> jsonSerializer) {
                        Class beanClass = beanDescription.getBeanClass();
                        if (Cause.class.isAssignableFrom(beanClass)) {
                            return new CauseSerializer(jsonSerializer);
                        }
                        if (StackTraceElement.class.isAssignableFrom(beanClass)) {
                            return new StackTraceElementSerializer();
                        }
                        return jsonSerializer;
                    }
                });
            }
        });
    }
}

