/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.EntityImpl;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubsegmentImpl
extends EntityImpl
implements Subsegment {
    private static final Log logger = LogFactory.getLog(SubsegmentImpl.class);
    private String namespace;
    private String resourceName;
    private Segment parentSegment;

    private SubsegmentImpl() {
    }

    public SubsegmentImpl(AWSXRayRecorder creator, String name, Segment parentSegment) {
        super(creator, name);
        this.parentSegment = parentSegment;
        parentSegment.incrementReferenceCount();
    }

    @Override
    public boolean end() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ending self. Parent segment named " + this.parentSegment.getName() + " has reference count " + this.parentSegment.getReferenceCount()));
        }
        this.setEndTime((double)Instant.now().toEpochMilli() / 1000.0);
        this.setInProgress(false);
        return this.parentSegment.decrementReferenceCount() && this.parentSegment.isSampled();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public Segment getParentSegment() {
        return this.parentSegment;
    }

    @Override
    public void setParentSegment(Segment parentSegment) {
        this.parentSegment = parentSegment;
    }

    @Override
    public String streamSerialize() {
        String ret = "";
        try {
            ObjectNode obj = (ObjectNode)mapper.valueToTree((Object)this);
            obj.put("type", "subsegment");
            obj.put("parent_id", this.getParentId());
            ret = mapper.writeValueAsString((Object)obj);
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)"Exception while serializing entity.", (Throwable)jpe);
        }
        return ret;
    }

    @Override
    public String prettyStreamSerialize() {
        String ret = "";
        try {
            ObjectNode obj = (ObjectNode)mapper.valueToTree((Object)this);
            obj.put("type", "subsegment");
            obj.put("parent_id", this.getParentId());
            ret = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)obj);
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)"Exception while serializing entity.", (Throwable)jpe);
        }
        return ret;
    }

    @Override
    public void close() throws Exception {
        this.getCreator().endSubsegment();
    }
}

