/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.javax.servlet;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.InetAddressValidator;

public class AWSXRayServletFilter
implements Filter {
    private static final String FALLBACK_NAME = "unknown_host";
    private static final String TRACING_NAME_KEY = "XRAY_TRACING_NAME";
    private static final String TRACING_DEFAULT_NAME_KEY = "XRAY_TRACING_DEFAULT_NAME";
    private String segmentOverrideName;
    private String segmentDefaultName;
    private static final Log logger = LogFactory.getLog(AWSXRayServletFilter.class);
    private AWSXRayRecorder recorder;
    private InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();

    public AWSXRayServletFilter() {
        this(AWSXRay.getGlobalRecorder());
    }

    public AWSXRayServletFilter(AWSXRayRecorder recorder) {
        this.recorder = recorder;
        this.segmentOverrideName = System.getenv(TRACING_NAME_KEY);
        if (null != this.segmentOverrideName) {
            logger.debug((Object)("XRAY_TRACING_NAME is set. All incoming requests will create segments named: " + this.segmentOverrideName));
        }
        this.segmentDefaultName = System.getenv(TRACING_DEFAULT_NAME_KEY);
        if (null != this.segmentDefaultName) {
            logger.debug((Object)("XRAY_TRACING_DEFAULT_NAME is set. Incoming requests without an IP address host header / no host header will create segments named: " + this.segmentDefaultName));
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.debug((Object)"Entering doFilter");
        Segment segment = this.preFilter(request, response);
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            if (null != segment) {
                segment.addException(e);
            }
            throw e;
        }
        finally {
            this.postFilter(request, response);
            logger.debug((Object)"Exiting doFilter");
        }
    }

    private HttpServletRequest castServletRequest(ServletRequest request) {
        try {
            return (HttpServletRequest)request;
        }
        catch (ClassCastException cce) {
            logger.warn((Object)"Unable to cast ServletRequest to HttpServletRequest.", (Throwable)cce);
            return null;
        }
    }

    private HttpServletResponse castServletResponse(ServletResponse response) {
        try {
            return (HttpServletResponse)response;
        }
        catch (ClassCastException cce) {
            logger.warn((Object)"Unable to cast ServletResponse to HttpServletResponse.", (Throwable)cce);
            return null;
        }
    }

    private Optional<TraceHeader> getTraceHeader(HttpServletRequest request) {
        String traceHeaderString = request.getHeader("X-Amzn-Trace-Id");
        if (null != traceHeaderString) {
            return Optional.of(TraceHeader.fromString(traceHeaderString));
        }
        return Optional.empty();
    }

    private Optional<String> getHost(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Host"));
    }

    private boolean matchesIpPattern(String host) {
        return null != host && this.inetAddressValidator.isValid(host);
    }

    private Optional<String> getClientIp(HttpServletRequest request) {
        return Optional.ofNullable(request.getRemoteAddr());
    }

    private Optional<String> getXForwardedFor(HttpServletRequest request) {
        String forwarded = null;
        forwarded = request.getHeader("X-Forwarded-For");
        if (forwarded != null) {
            return Optional.of(forwarded.split(",")[0].trim());
        }
        return Optional.empty();
    }

    private Optional<String> getUserAgent(HttpServletRequest request) {
        String userAgentHeaderString = request.getHeader("User-Agent");
        if (null != userAgentHeaderString) {
            return Optional.of(userAgentHeaderString);
        }
        return Optional.empty();
    }

    private String getSegmentName(HttpServletRequest httpServletRequest) {
        Optional<String> incomingHostName = this.getHost(httpServletRequest);
        if (null != this.segmentOverrideName) {
            logger.debug((Object)("Overriding segment name with provided segmentOverrideName: " + this.segmentOverrideName));
            return this.segmentOverrideName;
        }
        if (this.matchesIpPattern(incomingHostName.orElse(null))) {
            if (null != this.segmentDefaultName) {
                logger.debug((Object)("Host name matches IP address pattern. Overriding segment name with provided segmentDefaultName: " + this.segmentDefaultName));
                return this.segmentDefaultName;
            }
            logger.debug((Object)("Host name matches IP address pattern. But no segmentDefaultName was provided. Segment name will remain: " + incomingHostName.get()));
            return incomingHostName.get();
        }
        if (!incomingHostName.isPresent()) {
            logger.debug((Object)"Incoming request has no host header.");
            if (null != this.segmentDefaultName) {
                logger.debug((Object)("Overriding segment name with provided segmentDefaultName: " + this.segmentDefaultName));
                return this.segmentDefaultName;
            }
            logger.debug((Object)"No segmentDefaultName provided. Using hardcoded fallback segment name: unknown_host");
            return FALLBACK_NAME;
        }
        return incomingHostName.get();
    }

    private Segment preFilter(ServletRequest request, ServletResponse response) {
        Optional<String> xForwardedFor;
        Segment created = null;
        HttpServletRequest httpServletRequest = this.castServletRequest(request);
        if (null == httpServletRequest) {
            logger.warn((Object)"Null value for incoming HttpServletRequest. Beginning DummySegment.");
            return this.recorder.beginDummySegment();
        }
        Optional<String> incomingHostName = this.getHost(httpServletRequest);
        Optional<TraceHeader> incomingHeader = this.getTraceHeader(httpServletRequest);
        SamplingStrategy samplingStrategy = this.recorder.getSamplingStrategy();
        if (incomingHeader.isPresent()) {
            logger.debug((Object)"Incoming trace header received.");
            if (incomingHeader.get().getSampled().equals((Object)TraceHeader.SampleDecision.SAMPLED)) {
                logger.debug((Object)"Incoming trace header decided SAMPLED.");
                created = this.recorder.beginSegment(this.getSegmentName(httpServletRequest), incomingHeader.get().getRootTraceId(), incomingHeader.get().getParentId());
            } else if (incomingHeader.get().getSampled().equals((Object)TraceHeader.SampleDecision.NOT_SAMPLED)) {
                logger.debug((Object)"Incoming trace header decided NOT_SAMPLED.");
                if (samplingStrategy.isForcedSamplingSupported()) {
                    created = this.recorder.beginSegment(this.getSegmentName(httpServletRequest));
                    created.setSampled(false);
                }
            }
        } else if (samplingStrategy.shouldTrace(incomingHostName.orElse(null), httpServletRequest.getRequestURI(), httpServletRequest.getMethod())) {
            logger.debug((Object)"Sampling strategy decided SAMPLED.");
            created = this.recorder.beginSegment(this.getSegmentName(httpServletRequest));
        } else if (samplingStrategy.isForcedSamplingSupported()) {
            logger.debug((Object)"Sampling strategy decided NOT_SAMPLED, but forced sampling is enabled.");
            created = this.recorder.beginSegment(this.getSegmentName(httpServletRequest));
            created.setSampled(false);
        } else {
            logger.debug((Object)"Sampling strategy decided NOT_SAMPLED.");
            created = this.recorder.beginDummySegment();
        }
        HashMap<String, Object> requestAttributes = new HashMap<String, Object>();
        requestAttributes.put("url", httpServletRequest.getRequestURL().toString());
        requestAttributes.put("method", httpServletRequest.getMethod());
        Optional<String> userAgent = this.getUserAgent(httpServletRequest);
        if (userAgent.isPresent()) {
            requestAttributes.put("user_agent", userAgent.get());
        }
        if ((xForwardedFor = this.getXForwardedFor(httpServletRequest)).isPresent()) {
            requestAttributes.put("client_ip", xForwardedFor.get());
            requestAttributes.put("x_forwarded_for", true);
        } else {
            Optional<String> clientIp = this.getClientIp(httpServletRequest);
            if (clientIp.isPresent()) {
                requestAttributes.put("client_ip", clientIp.get());
            }
        }
        created.putHttp("request", requestAttributes);
        HttpServletResponse httpServletResponse = this.castServletResponse(response);
        if (null == response) {
            return created;
        }
        TraceHeader responseHeader = null;
        if (incomingHeader.isPresent()) {
            responseHeader = new TraceHeader(created.getTraceId());
            if (TraceHeader.SampleDecision.REQUESTED == incomingHeader.get().getSampled()) {
                responseHeader.setSampled(created.isSampled() ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED);
            }
        } else {
            responseHeader = new TraceHeader(created.getTraceId());
        }
        httpServletResponse.addHeader("X-Amzn-Trace-Id", responseHeader.toString());
        return created;
    }

    private Optional<Integer> getContentLength(HttpServletResponse response) {
        String contentLengthString = response.getHeader("Content-Length");
        if (null != contentLengthString && !contentLengthString.isEmpty()) {
            try {
                return Optional.of(Integer.parseInt(contentLengthString));
            }
            catch (NumberFormatException nfe) {
                logger.debug((Object)"Unable to parse Content-Length header from HttpServletResponse.", (Throwable)nfe);
            }
        }
        return Optional.empty();
    }

    private void postFilter(ServletRequest request, ServletResponse response) {
        Segment segment = this.recorder.getCurrentSegment();
        if (null != segment) {
            HttpServletResponse httpServletResponse = this.castServletResponse(response);
            if (null != httpServletResponse) {
                HashMap<String, Integer> responseAttributes = new HashMap<String, Integer>();
                int responseCode = httpServletResponse.getStatus();
                switch (responseCode / 100) {
                    case 4: {
                        segment.setError(true);
                        if (responseCode != 429) break;
                        segment.setThrottle(true);
                        break;
                    }
                    case 5: {
                        segment.setFault(true);
                        break;
                    }
                }
                responseAttributes.put("status", responseCode);
                Optional<Integer> contentLength = this.getContentLength(httpServletResponse);
                if (contentLength.isPresent()) {
                    responseAttributes.put("content_length", contentLength.get());
                }
                segment.putHttp("response", responseAttributes);
            }
            this.recorder.endSegment();
        }
    }

    public void destroy() {
    }

    public String getSegmentOverrideName() {
        return this.segmentOverrideName;
    }

    public void setSegmentOverrideName(String segmentOverrideName) {
        this.segmentOverrideName = segmentOverrideName;
    }

    public String getSegmentDefaultName() {
        return this.segmentDefaultName;
    }

    public void setSegmentDefaultName(String segmentDefaultName) {
        this.segmentDefaultName = segmentDefaultName;
    }
}

