/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.plugins;

import com.amazonaws.xray.plugins.Plugin;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ECSPlugin
implements Plugin {
    private static final Log logger = LogFactory.getLog(ECSPlugin.class);
    private static final String SERVICE_NAME = "ecs";
    private HashMap<String, Object> runtimeContext = new HashMap();
    private static final String ORIGIN = "AWS::ECS::Container";

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void populateRuntimeContext() {
        try {
            this.runtimeContext.put("container", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            logger.error((Object)"Could not get docker container ID from hostname.", (Throwable)uhe);
        }
    }

    @Override
    public Map<String, Object> getRuntimeContext() {
        this.populateRuntimeContext();
        return this.runtimeContext;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }
}

