/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.serializers;

import com.amazonaws.xray.entities.Cause;
import com.amazonaws.xray.entities.ThrowableDescription;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class CauseSerializer
extends JsonSerializer<Cause> {
    private JsonSerializer<Object> objectSerializer;

    public CauseSerializer() {
        this(null);
    }

    public CauseSerializer(JsonSerializer<Object> objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    public void serialize(Cause cause, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ThrowableDescription first;
        if (!cause.getExceptions().isEmpty() && null == (first = cause.getExceptions().get(0)).getId() && null != first.getCause()) {
            jsonGenerator.writeString(first.getCause());
            return;
        }
        this.objectSerializer.serialize((Object)cause, jsonGenerator, serializerProvider);
    }

    public boolean isEmpty(SerializerProvider serializerProvider, Cause cause) {
        return null == cause || cause.getExceptions().isEmpty() && null == cause.getId();
    }
}

