/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling;

import com.amazonaws.xray.strategy.sampling.SamplingRule;
import com.amazonaws.xray.strategy.sampling.SamplingRuleManifest;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizedSamplingStrategy
implements SamplingStrategy {
    private static final Log logger = LogFactory.getLog(LocalizedSamplingStrategy.class);
    private static final URL DEFAULT_RULES = LocalizedSamplingStrategy.class.getResource("/com/amazonaws/xray/strategy/sampling/DefaultSamplingRules.json");
    private final SamplingRule DEFAULT_RULE = new SamplingRule(Integer.MAX_VALUE, "*", "*", "*", 1, 0.05f);
    private boolean fallbackMode = false;
    private volatile ArrayList<SamplingRule> rules;
    private ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true);

    public LocalizedSamplingStrategy() {
        this(DEFAULT_RULES);
    }

    public LocalizedSamplingStrategy(URL ruleLocation) {
        this.processRuleManifest(this.getRuleManifest(ruleLocation));
    }

    private SamplingRuleManifest getRuleManifest(URL ruleLocation) {
        if (null == ruleLocation) {
            logger.error((Object)("Unable to parse null URL. Falling back to default rule set: " + DEFAULT_RULES.getPath()));
            return this.getDefaultRuleManifest();
        }
        try {
            return (SamplingRuleManifest)this.mapper.readValue(ruleLocation, SamplingRuleManifest.class);
        }
        catch (IOException ioe) {
            logger.error((Object)("Unable to parse " + ruleLocation.getPath() + ". Falling back to default rule set: " + DEFAULT_RULES.getPath()), (Throwable)ioe);
            return this.getDefaultRuleManifest();
        }
    }

    private SamplingRuleManifest getDefaultRuleManifest() {
        try {
            return (SamplingRuleManifest)this.mapper.readValue(DEFAULT_RULES, SamplingRuleManifest.class);
        }
        catch (IOException ioe2) {
            logger.error((Object)("Unable to parse " + DEFAULT_RULES + ". Falling back to default (1 request per second / 5% otherwise) sampling."));
            this.fallbackMode = true;
            return null;
        }
    }

    private void processRuleManifest(SamplingRuleManifest manifest) {
        if (null != manifest) {
            this.rules = new ArrayList<SamplingRule>(manifest.getRules().values());
            Collections.sort(this.rules);
        }
    }

    @Override
    public boolean shouldTrace(String serviceName, String path, String method) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Determining shouldTrace decision for:\n\tserviceName: " + serviceName + "\n\tpath: " + path + "\n\tmethod: " + method));
        }
        if (this.fallbackMode) {
            return this.shouldTrace(this.DEFAULT_RULE);
        }
        SamplingRule firstApplicableRule = this.rules.stream().filter(rule -> rule.appliesTo(serviceName, path, method)).findFirst().orElse(null);
        return null == firstApplicableRule ? false : this.shouldTrace(firstApplicableRule);
    }

    private boolean shouldTrace(SamplingRule samplingRule) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applicable sampling rule: " + samplingRule));
        }
        if (samplingRule.getReservoir().take()) {
            return true;
        }
        return ThreadLocalRandom.current().nextFloat() < samplingRule.getRate();
    }

    @Override
    public boolean isForcedSamplingSupported() {
        return false;
    }
}

