/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling;

import com.amazonaws.xray.strategy.sampling.Reservoir;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SamplingRule
implements Comparable<SamplingRule> {
    private static final Log logger = LogFactory.getLog(SamplingRule.class);
    private int id;
    private String serviceName;
    private String httpMethod;
    private String urlPath;
    private int fixedTarget;
    private float rate;
    private Pattern serviceNamePattern;
    private Pattern httpMethodPattern;
    private Pattern urlPathPattern;
    private Reservoir reservoir;

    public SamplingRule() {
        this.reservoir = new Reservoir();
    }

    public SamplingRule(int id, String serviceName, String httpMethod, String urlPath, int fixedTarget, float rate) {
        this.serviceName = serviceName;
        this.httpMethod = httpMethod;
        this.urlPath = urlPath;
        this.fixedTarget = fixedTarget;
        this.rate = rate;
        this.serviceNamePattern = this.compilePattern(serviceName);
        this.httpMethodPattern = this.compilePattern(httpMethod);
        this.urlPathPattern = this.compilePattern(urlPath);
        this.reservoir = new Reservoir(fixedTarget);
    }

    private Pattern compilePattern(String pattern) {
        return Pattern.compile(pattern.replaceAll("[^\\\\]?\\*", ".*").replaceAll("[^\\\\]?\\?", ".?"));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.serviceNamePattern = this.compilePattern(serviceName);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        this.httpMethodPattern = this.compilePattern(httpMethod);
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
        this.urlPathPattern = this.compilePattern(urlPath);
    }

    public int getFixedTarget() {
        return this.fixedTarget;
    }

    public void setFixedTarget(int fixedTarget) {
        this.fixedTarget = fixedTarget;
        this.reservoir = new Reservoir(fixedTarget);
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public Reservoir getReservoir() {
        return this.reservoir;
    }

    @Override
    public int compareTo(SamplingRule otherRule) {
        return Integer.compare(this.id, otherRule.getId());
    }

    public String toString() {
        return "\n\tid: " + this.id + "\n\tservice_name: " + this.serviceName + "\n\thttp_method: " + this.httpMethod + "\n\turl_path: " + this.urlPath + "\n\tfixed_target: " + this.fixedTarget + "\n\trate: " + this.rate;
    }

    public boolean appliesTo(String serviceName, String path, String method) {
        return (serviceName == null || this.serviceNamePattern.matcher(serviceName).matches()) && this.urlPathPattern.matcher(path).matches() && this.httpMethodPattern.matcher(method).matches();
    }
}

