/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.DefaultFilterInfo;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MultiDelimiterInterpolatorFilterReaderLineEnding;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.multi.MultiDelimiterStringSearchInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseFilter
implements DefaultFilterInfo {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    BaseFilter() {
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public List<FilterWrapper> getDefaultFilterWrappers(MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession, MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        MavenResourcesExecution mre = mavenResourcesExecution == null ? new MavenResourcesExecution() : mavenResourcesExecution.copyOf();
        mre.setMavenProject(mavenProject);
        mre.setMavenSession(mavenSession);
        mre.setFilters(filters);
        mre.setEscapedBackslashesInFilePath(escapedBackslashesInFilePath);
        return this.getDefaultFilterWrappers(mre);
    }

    @Override
    public List<FilterWrapper> getDefaultFilterWrappers(AbstractMavenFilteringRequest request) throws MavenFilteringException {
        boolean supportMultiLineFiltering = request.isSupportMultiLineFiltering();
        request.setSupportMultiLineFiltering(supportMultiLineFiltering);
        Properties baseProps = new Properties();
        if (request.getMavenProject() != null) {
            baseProps.putAll((Map<?, ?>)(request.getMavenProject().getProperties() == null ? Collections.emptyMap() : request.getMavenProject().getProperties()));
        }
        if (request.getMavenSession() != null) {
            BaseFilter.putAll(baseProps, request.getMavenSession().getSystemProperties());
            BaseFilter.putAll(baseProps, request.getMavenSession().getUserProperties());
        }
        Properties filterProperties = new Properties();
        File basedir = request.getMavenProject() != null ? request.getMavenProject().getBasedir() : new File(".");
        this.loadProperties(filterProperties, basedir, request.getFileFilters(), baseProps);
        if (filterProperties.isEmpty()) {
            BaseFilter.putAll(filterProperties, baseProps);
        }
        if (request.getMavenProject() != null) {
            if (request.isInjectProjectBuildFilters()) {
                ArrayList<String> buildFilters = new ArrayList<String>(request.getMavenProject().getBuild().getFilters());
                if (request.getFileFilters() != null) {
                    buildFilters.removeAll(request.getFileFilters());
                }
                this.loadProperties(filterProperties, basedir, buildFilters, baseProps);
            }
            filterProperties.putAll((Map<?, ?>)(request.getMavenProject().getProperties() == null ? Collections.emptyMap() : request.getMavenProject().getProperties()));
        }
        if (request.getMavenSession() != null) {
            BaseFilter.putAll(filterProperties, request.getMavenSession().getSystemProperties());
            BaseFilter.putAll(filterProperties, request.getMavenSession().getUserProperties());
        }
        if (request.getAdditionalProperties() != null) {
            BaseFilter.putAll(filterProperties, request.getAdditionalProperties());
        }
        ArrayList<FilterWrapper> defaultFilterWrappers = new ArrayList<FilterWrapper>(request.getDelimiters().size() + 1);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("properties used:");
            for (String s : new TreeSet<String>(filterProperties.stringPropertyNames())) {
                this.getLogger().debug(s + ": " + filterProperties.getProperty(s));
            }
        }
        PropertiesBasedValueSource propertiesValueSource = new PropertiesBasedValueSource(filterProperties);
        Wrapper wrapper = new Wrapper(request.getDelimiters(), request.getMavenProject(), request.getMavenSession(), (ValueSource)propertiesValueSource, request.getProjectStartExpressions(), request.getEscapeString(), request.isEscapeWindowsPaths(), request.isSupportMultiLineFiltering());
        defaultFilterWrappers.add(wrapper);
        return defaultFilterWrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putAll(Properties filterProperties, Properties request) {
        Properties properties = request;
        synchronized (properties) {
            filterProperties.putAll((Map<?, ?>)request);
        }
    }

    void loadProperties(Properties filterProperties, File basedir, List<String> propertiesFilePaths, Properties baseProps) throws MavenFilteringException {
        if (propertiesFilePaths != null) {
            Properties workProperties = new Properties();
            BaseFilter.putAll(workProperties, baseProps);
            for (String filterFile : propertiesFilePaths) {
                if (filterFile == null || filterFile.trim().isEmpty()) continue;
                try {
                    File propFile = FilteringUtils.resolveFile(basedir, filterFile);
                    Properties properties = PropertyUtils.loadPropertyFile(propFile, workProperties, this.getLogger());
                    BaseFilter.putAll(filterProperties, properties);
                    BaseFilter.putAll(workProperties, properties);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Error loading property file '" + filterFile + "'", e);
                }
            }
        }
    }

    private static Interpolator createInterpolator(LinkedHashSet<String> delimiters, List<String> projectStartExpressions, ValueSource propertiesValueSource, MavenProject project, MavenSession mavenSession, String escapeString, boolean escapeWindowsPaths) {
        MultiDelimiterStringSearchInterpolator interpolator = new MultiDelimiterStringSearchInterpolator();
        interpolator.setDelimiterSpecs(delimiters);
        interpolator.addValueSource(propertiesValueSource);
        if (project != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(projectStartExpressions, (Object)project, true));
        }
        if (mavenSession != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("session", (Object)mavenSession));
            Settings settings = mavenSession.getSettings();
            if (settings != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)settings));
                interpolator.addValueSource((ValueSource)new SingleResponseValueSource("localRepository", (Object)settings.getLocalRepository()));
            }
        }
        interpolator.setEscapeString(escapeString);
        if (escapeWindowsPaths) {
            interpolator.addPostProcessor((expression, value) -> value instanceof String ? FilteringUtils.escapeWindowsPath((String)value) : value);
        }
        return interpolator;
    }

    private static final class Wrapper
    extends FilterWrapper {
        private LinkedHashSet<String> delimiters;
        private MavenProject project;
        private ValueSource propertiesValueSource;
        private List<String> projectStartExpressions;
        private String escapeString;
        private boolean escapeWindowsPaths;
        private final MavenSession mavenSession;
        private boolean supportMultiLineFiltering;

        Wrapper(LinkedHashSet<String> delimiters, MavenProject project, MavenSession mavenSession, ValueSource propertiesValueSource, List<String> projectStartExpressions, String escapeString, boolean escapeWindowsPaths, boolean supportMultiLineFiltering) {
            this.delimiters = delimiters;
            this.project = project;
            this.mavenSession = mavenSession;
            this.propertiesValueSource = propertiesValueSource;
            this.projectStartExpressions = projectStartExpressions;
            this.escapeString = escapeString;
            this.escapeWindowsPaths = escapeWindowsPaths;
            this.supportMultiLineFiltering = supportMultiLineFiltering;
        }

        @Override
        public Reader getReader(Reader reader) {
            Interpolator interpolator = BaseFilter.createInterpolator(this.delimiters, this.projectStartExpressions, this.propertiesValueSource, this.project, this.mavenSession, this.escapeString, this.escapeWindowsPaths);
            MultiDelimiterInterpolatorFilterReaderLineEnding filterReader = new MultiDelimiterInterpolatorFilterReaderLineEnding(reader, interpolator, this.supportMultiLineFiltering);
            Object ri = this.projectStartExpressions != null && !this.projectStartExpressions.isEmpty() ? new PrefixAwareRecursionInterceptor(this.projectStartExpressions, true) : new SimpleRecursionInterceptor();
            filterReader.setRecursionInterceptor((RecursionInterceptor)ri);
            filterReader.setDelimiterSpecs(this.delimiters);
            filterReader.setInterpolateWithPrefixPattern(false);
            filterReader.setEscapeString(this.escapeString);
            return filterReader;
        }
    }
}

