/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

@Named(value="evaluateBeanshell")
public final class EvaluateBeanshell
extends AbstractStandardEnforcerRule {
    private final Interpreter interpreter = new Interpreter();
    private String condition;
    private final ExpressionEvaluator evaluator;

    @Inject
    public EvaluateBeanshell(ExpressionEvaluator evaluator) {
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void execute() throws EnforcerRuleException {
        try {
            this.getLog().debug((CharSequence)("Echo condition : " + this.condition));
            String script = (String)this.evaluator.evaluate(this.condition);
            this.getLog().debug((CharSequence)("Echo script : " + script));
            if (!this.evaluateCondition(script)) {
                String message = this.getMessage();
                if (message == null || message.isEmpty()) {
                    message = "The expression \"" + this.condition + "\" is not true.";
                }
                throw new EnforcerRuleException(message);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to evaluate an expression '" + this.condition + "'", (Exception)((Object)e));
        }
    }

    private boolean evaluateCondition(String script) throws EnforcerRuleException {
        Boolean evaluation;
        try {
            evaluation = (Boolean)this.interpreter.eval(script);
            this.getLog().debug((CharSequence)("Echo evaluating : " + evaluation));
        }
        catch (EvalError ex) {
            throw new EnforcerRuleException("Couldn't evaluate condition: " + script, (Exception)((Object)ex));
        }
        return evaluation;
    }

    public String toString() {
        return String.format("EvaluateBeanshell[message=%s, condition=%s]", this.getMessage(), this.condition);
    }
}

