/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

@Named(value="requireMatchingCoordinates")
public final class RequireMatchingCoordinates
extends AbstractStandardEnforcerRule {
    private Pattern groupIdPattern;
    private Pattern artifactIdPattern;
    private boolean moduleNameMustMatchArtifactId;
    private final MavenProject project;

    @Inject
    public RequireMatchingCoordinates(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        StringBuilder msgBuilder = new StringBuilder();
        if (this.groupIdPattern != null && !this.groupIdPattern.matcher(this.project.getGroupId()).matches()) {
            msgBuilder.append("Group ID must match pattern \"").append(this.groupIdPattern).append("\" but is \"").append(this.project.getGroupId()).append("\"");
        }
        if (this.artifactIdPattern != null && !this.artifactIdPattern.matcher(this.project.getArtifactId()).matches()) {
            if (msgBuilder.length() > 0) {
                msgBuilder.append(System.lineSeparator());
            }
            msgBuilder.append("Artifact ID must match pattern \"").append(this.artifactIdPattern).append("\" but is \"").append(this.project.getArtifactId()).append("\"");
        }
        if (this.moduleNameMustMatchArtifactId && !this.project.isExecutionRoot() && !this.project.getBasedir().getName().equals(this.project.getArtifactId())) {
            if (msgBuilder.length() > 0) {
                msgBuilder.append(System.lineSeparator());
            }
            msgBuilder.append("Module directory name must be equal to its artifact ID \"").append(this.project.getArtifactId()).append("\" but is \"").append(this.project.getBasedir().getName()).append("\"");
        }
        if (msgBuilder.length() > 0) {
            throw new EnforcerRuleException(msgBuilder.toString());
        }
    }

    public void setGroupIdPattern(String groupIdPattern) {
        this.groupIdPattern = Pattern.compile(groupIdPattern);
    }

    public void setArtifactIdPattern(String artifactIdPattern) {
        this.artifactIdPattern = Pattern.compile(artifactIdPattern);
    }

    public void setModuleNameMustMatchArtifactId(boolean moduleNameMustMatchArtifactId) {
        this.moduleNameMustMatchArtifactId = moduleNameMustMatchArtifactId;
    }

    public String toString() {
        return String.format("requireMatchingCoordinates[groupIdPattern=%s, artifactIdPattern=%s, moduleNameMustMatchArtifactId=%b]", this.groupIdPattern, this.artifactIdPattern, this.moduleNameMustMatchArtifactId);
    }
}

