# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
# SPDX-License-Identifier: MIT-0

import os

from idt_client import ExecuteOnDeviceRequest, CopyToDeviceRequest, ExecuteOnDeviceCommand

dut_file_path = 'testFile.txt'


class CatTest:
    def __init__(self, client):
        self._client = client

    # Tests that the cat command on the device functions properly:
    # This test copies a file to the device, uses the cat command on device to get the contents,
    # and then compares that with the local file contents.
    def run(self):
        # Copy the test file to the device
        local_file_path = os.path.join(os.getcwd(), 'testFile.txt')
        copy_to_device_request = CopyToDeviceRequest(local_file_path, dut_file_path)
        self._client.copy_to_device(copy_to_device_request)

        # Get contents of the copied file
        command = ExecuteOnDeviceCommand(f'cat {dut_file_path}')
        execute_on_device_request = ExecuteOnDeviceRequest(command)
        execute_on_device_response = self._client.execute_on_device(execute_on_device_request)

        print("Execute on device response:", execute_on_device_response)

        # Assert that the file contents are the same
        output = execute_on_device_response.stdout.decode()
        with open(local_file_path) as local:
            if output != local.read():
                return "Local file contents doesn't match remote contents"

        return None

    # This test copies a file to the device. In order to clean up that created resource, the file needs to be deleted.
    def cleanup(self):
        command = ExecuteOnDeviceCommand(f'rm {dut_file_path}')
        execute_on_device_request = ExecuteOnDeviceRequest(command)
        self._client.execute_on_device(execute_on_device_request)
